#version 140
#extension GL_EXT_gpu_shader4 : enable
// Pseudo FluidMod01.fsh by SnoopethDuckDuck
//https://www.shadertoy.com/view/7sjfWy

// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
#define iTime u_Elapsed*.177  //one tenth sqrt of pi
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)





#define pi 3.14159
#define Rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))
#define thc(a,b) tanh(a*cos(b))/tanh(a)

vec3 pal(in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d) {
    return a + b*cos( 6.28318*(c*t+d) );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
    
    // larger n -> larger chain of dots
    float n = 12.;    
    for (float i = 0.; i < n; i++) {
        float io = 8. * pi * i / n;
        float s = sign(uv.x);
        uv *= Rot(thc(1.5, io + 8. * length(uv) - iTime) * s * pi / n);
        uv -= 0.024 * s; // increase multiplier to get bigger flames
    }
    
    float s = exp(0.05 - 2.5 * length(uv));
    vec3 e = vec3(1);    
    vec3 col = s * pal(0.2 + 0.25 * length(uv), e, e, e, 0.35 * vec3(0,1,2)/3.);
    col = sqrt(col) + 0.08;
    gl_FragColor = vec4(col,1.0);
}
